/*
 * Decompiled with CFR 0.152.
 */
package org.python.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.python.google.common.base.Preconditions;
import org.python.google.common.collect.EmptyImmutableMap;
import org.python.google.common.collect.ImmutableCollection;
import org.python.google.common.collect.ImmutableSet;
import org.python.google.common.collect.ImmutableSortedMap;
import org.python.google.common.collect.Iterables;
import org.python.google.common.collect.Lists;
import org.python.google.common.collect.Maps;
import org.python.google.common.collect.RegularImmutableMap;
import org.python.google.common.collect.SingletonImmutableMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@GwtCompatible(serializable=true, emulated=true)
public abstract class ImmutableMap<K, V>
implements Map<K, V>,
Serializable {
    public static <K, V> ImmutableMap<K, V> of() {
        return EmptyImmutableMap.INSTANCE;
    }

    public static <K, V> ImmutableMap<K, V> of(K k, V v) {
        return new SingletonImmutableMap<K, V>(Preconditions.checkNotNull(k), Preconditions.checkNotNull(v));
    }

    public static <K, V> ImmutableMap<K, V> of(K k, V v, K k2, V v2) {
        return new RegularImmutableMap(ImmutableMap.entryOf(k, v), ImmutableMap.entryOf(k2, v2));
    }

    public static <K, V> ImmutableMap<K, V> of(K k, V v, K k2, V v2, K k3, V v3) {
        return new RegularImmutableMap(ImmutableMap.entryOf(k, v), ImmutableMap.entryOf(k2, v2), ImmutableMap.entryOf(k3, v3));
    }

    public static <K, V> ImmutableMap<K, V> of(K k, V v, K k2, V v2, K k3, V v3, K k4, V v4) {
        return new RegularImmutableMap(ImmutableMap.entryOf(k, v), ImmutableMap.entryOf(k2, v2), ImmutableMap.entryOf(k3, v3), ImmutableMap.entryOf(k4, v4));
    }

    public static <K, V> ImmutableMap<K, V> of(K k, V v, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5) {
        return new RegularImmutableMap(ImmutableMap.entryOf(k, v), ImmutableMap.entryOf(k2, v2), ImmutableMap.entryOf(k3, v3), ImmutableMap.entryOf(k4, v4), ImmutableMap.entryOf(k5, v5));
    }

    public static <K, V> Builder<K, V> builder() {
        return new Builder();
    }

    static <K, V> Map.Entry<K, V> entryOf(K k, V v) {
        return Maps.immutableEntry(Preconditions.checkNotNull(k, "null key"), Preconditions.checkNotNull(v, "null value"));
    }

    public static <K, V> ImmutableMap<K, V> copyOf(Map<? extends K, ? extends V> map) {
        Map.Entry[] entryArray;
        if (map instanceof ImmutableMap && !(map instanceof ImmutableSortedMap) && !(entryArray = (Map.Entry[])map).isPartialView()) {
            return entryArray;
        }
        entryArray = map.entrySet().toArray(new Map.Entry[0]);
        switch (entryArray.length) {
            case 0: {
                return ImmutableMap.of();
            }
            case 1: {
                return new SingletonImmutableMap(ImmutableMap.entryOf(entryArray[0].getKey(), entryArray[0].getValue()));
            }
        }
        for (int i = 0; i < entryArray.length; ++i) {
            Object k = entryArray[i].getKey();
            Object v = entryArray[i].getValue();
            entryArray[i] = ImmutableMap.entryOf(k, v);
        }
        return new RegularImmutableMap(entryArray);
    }

    ImmutableMap() {
    }

    @Override
    public final V put(K k, V v) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final V remove(Object object) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final void putAll(Map<? extends K, ? extends V> map) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean containsKey(@Nullable Object object) {
        return this.get(object) != null;
    }

    @Override
    public abstract boolean containsValue(@Nullable Object var1);

    @Override
    public abstract V get(@Nullable Object var1);

    @Override
    public abstract ImmutableSet<Map.Entry<K, V>> entrySet();

    @Override
    public abstract ImmutableSet<K> keySet();

    @Override
    public abstract ImmutableCollection<V> values();

    @Override
    public boolean equals(@Nullable Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof Map) {
            Map map = (Map)object;
            return ((ImmutableSet)this.entrySet()).equals(map.entrySet());
        }
        return false;
    }

    abstract boolean isPartialView();

    @Override
    public int hashCode() {
        return ((ImmutableSet)this.entrySet()).hashCode();
    }

    public String toString() {
        return Maps.toStringImpl(this);
    }

    Object writeReplace() {
        return new SerializedForm(this);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Builder<K, V> {
        final List<Map.Entry<K, V>> entries = Lists.newArrayList();

        public Builder<K, V> put(K k, V v) {
            this.entries.add(ImmutableMap.entryOf(k, v));
            return this;
        }

        public Builder<K, V> putAll(Map<? extends K, ? extends V> map) {
            for (Map.Entry<K, V> entry : map.entrySet()) {
                this.put(entry.getKey(), entry.getValue());
            }
            return this;
        }

        public ImmutableMap<K, V> build() {
            return Builder.fromEntryList(this.entries);
        }

        private static <K, V> ImmutableMap<K, V> fromEntryList(List<Map.Entry<K, V>> list) {
            int n = list.size();
            switch (n) {
                case 0: {
                    return ImmutableMap.of();
                }
                case 1: {
                    return new SingletonImmutableMap<K, V>(Iterables.getOnlyElement(list));
                }
            }
            Map.Entry[] entryArray = list.toArray(new Map.Entry[list.size()]);
            return new RegularImmutableMap(entryArray);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class SerializedForm
    implements Serializable {
        private final Object[] keys;
        private final Object[] values;
        private static final long serialVersionUID = 0L;

        SerializedForm(ImmutableMap<?, ?> immutableMap) {
            this.keys = new Object[immutableMap.size()];
            this.values = new Object[immutableMap.size()];
            int n = 0;
            for (Map.Entry entry : immutableMap.entrySet()) {
                this.keys[n] = entry.getKey();
                this.values[n] = entry.getValue();
                ++n;
            }
        }

        Object readResolve() {
            Builder<Object, Object> builder = new Builder<Object, Object>();
            return this.createMap(builder);
        }

        Object createMap(Builder<Object, Object> builder) {
            for (int i = 0; i < this.keys.length; ++i) {
                builder.put(this.keys[i], this.values[i]);
            }
            return builder.build();
        }
    }
}

